/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import sun.security.util.ECKeySizeParameterSpec;
import sun.security.x509.X509Key;

public final class ECUtil {
    public static ECPoint decodePoint(byte[] byArray, EllipticCurve ellipticCurve) throws IOException {
        if (byArray.length == 0 || byArray[0] != 4) {
            throw new IOException("Only uncompressed point format supported");
        }
        int n = (byArray.length - 1) / 2;
        if (n != ellipticCurve.getField().getFieldSize() + 7 >> 3) {
            throw new IOException("Point does not match field size");
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, 1, 1 + n);
        byte[] byArray3 = Arrays.copyOfRange(byArray, n + 1, n + 1 + n);
        return new ECPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    public static byte[] encodePoint(ECPoint eCPoint, EllipticCurve ellipticCurve) {
        int n = ellipticCurve.getField().getFieldSize() + 7 >> 3;
        byte[] byArray = ECUtil.trimZeroes(eCPoint.getAffineX().toByteArray());
        byte[] byArray2 = ECUtil.trimZeroes(eCPoint.getAffineY().toByteArray());
        if (byArray.length > n || byArray2.length > n) {
            throw new RuntimeException("Point coordinates do not match field size");
        }
        byte[] byArray3 = new byte[1 + (n << 1)];
        byArray3[0] = 4;
        System.arraycopy(byArray, 0, byArray3, n - byArray.length + 1, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
        return byArray3;
    }

    public static byte[] trimZeroes(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length - 1 && byArray[n] == 0; ++n) {
        }
        if (n == 0) {
            return byArray;
        }
        return Arrays.copyOfRange(byArray, n, byArray.length);
    }

    private static KeyFactory getKeyFactory() {
        try {
            return KeyFactory.getInstance("EC", "SunEC");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
    }

    public static ECPublicKey decodeX509ECPublicKey(byte[] byArray) throws InvalidKeySpecException {
        KeyFactory keyFactory = ECUtil.getKeyFactory();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        return (ECPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
    }

    public static byte[] x509EncodeECPublicKey(ECPoint eCPoint, ECParameterSpec eCParameterSpec) throws InvalidKeySpecException {
        KeyFactory keyFactory = ECUtil.getKeyFactory();
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
        X509Key x509Key = (X509Key)keyFactory.generatePublic(eCPublicKeySpec);
        return x509Key.getEncoded();
    }

    public static ECPrivateKey decodePKCS8ECPrivateKey(byte[] byArray) throws InvalidKeySpecException {
        KeyFactory keyFactory = ECUtil.getKeyFactory();
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        return (ECPrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
    }

    public static ECPrivateKey generateECPrivateKey(BigInteger bigInteger, ECParameterSpec eCParameterSpec) throws InvalidKeySpecException {
        KeyFactory keyFactory = ECUtil.getKeyFactory();
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(bigInteger, eCParameterSpec);
        return (ECPrivateKey)keyFactory.generatePrivate(eCPrivateKeySpec);
    }

    private static AlgorithmParameters getECParameters(Provider provider) {
        try {
            if (provider != null) {
                return AlgorithmParameters.getInstance("EC", provider);
            }
            return AlgorithmParameters.getInstance("EC");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public static byte[] encodeECParameterSpec(Provider provider, ECParameterSpec eCParameterSpec) {
        AlgorithmParameters algorithmParameters = ECUtil.getECParameters(provider);
        try {
            algorithmParameters.init(eCParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException("Not a known named curve: " + eCParameterSpec);
        }
        try {
            return algorithmParameters.getEncoded();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static ECParameterSpec getECParameterSpec(Provider provider, ECParameterSpec eCParameterSpec) {
        AlgorithmParameters algorithmParameters = ECUtil.getECParameters(provider);
        try {
            algorithmParameters.init(eCParameterSpec);
            return algorithmParameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    public static ECParameterSpec getECParameterSpec(Provider provider, byte[] byArray) throws IOException {
        AlgorithmParameters algorithmParameters = ECUtil.getECParameters(provider);
        algorithmParameters.init(byArray);
        try {
            return algorithmParameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    public static ECParameterSpec getECParameterSpec(Provider provider, String string) {
        AlgorithmParameters algorithmParameters = ECUtil.getECParameters(provider);
        try {
            algorithmParameters.init(new ECGenParameterSpec(string));
            return algorithmParameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    public static ECParameterSpec getECParameterSpec(Provider provider, int n) {
        AlgorithmParameters algorithmParameters = ECUtil.getECParameters(provider);
        try {
            algorithmParameters.init(new ECKeySizeParameterSpec(n));
            return algorithmParameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    public static String getCurveName(Provider provider, ECParameterSpec eCParameterSpec) {
        ECGenParameterSpec eCGenParameterSpec;
        AlgorithmParameters algorithmParameters = ECUtil.getECParameters(provider);
        try {
            algorithmParameters.init(eCParameterSpec);
            eCGenParameterSpec = algorithmParameters.getParameterSpec(ECGenParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
        if (eCGenParameterSpec == null) {
            return null;
        }
        return eCGenParameterSpec.getName();
    }

    public static boolean equals(ECParameterSpec eCParameterSpec, ECParameterSpec eCParameterSpec2) {
        if (eCParameterSpec == eCParameterSpec2) {
            return true;
        }
        if (eCParameterSpec == null || eCParameterSpec2 == null) {
            return false;
        }
        return eCParameterSpec.getCofactor() == eCParameterSpec2.getCofactor() && eCParameterSpec.getOrder().equals(eCParameterSpec2.getOrder()) && eCParameterSpec.getCurve().equals(eCParameterSpec2.getCurve()) && eCParameterSpec.getGenerator().equals(eCParameterSpec2.getGenerator());
    }

    private ECUtil() {
    }
}

