/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.ObjectClassGenerator;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;

final class AllocationStrategy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final AllocationStrategy DEFAULT_STRATEGY = new AllocationStrategy(new ObjectClassGenerator.AllocatorDescriptor(0));
    private final PropertyMap allocatorMap;
    private final String allocatorClassName;
    private transient MethodHandle allocator;

    private AllocationStrategy(ObjectClassGenerator.AllocatorDescriptor desc) {
        this.allocatorMap = desc.getAllocatorMap();
        this.allocatorClassName = desc.getAllocatorClassName().intern();
    }

    private boolean matches(ObjectClassGenerator.AllocatorDescriptor desc) {
        return desc.getAllocatorMap().size() == this.allocatorMap.size() && desc.getAllocatorClassName().equals(this.allocatorClassName);
    }

    static AllocationStrategy get(ObjectClassGenerator.AllocatorDescriptor desc) {
        return DEFAULT_STRATEGY.matches(desc) ? DEFAULT_STRATEGY : new AllocationStrategy(desc);
    }

    PropertyMap getAllocatorMap() {
        return this.allocatorMap;
    }

    ScriptObject allocate(PropertyMap map) {
        try {
            if (this.allocator == null) {
                this.allocator = Lookup.MH.findStatic(LOOKUP, Context.forStructureClass(this.allocatorClassName), CompilerConstants.ALLOCATE.symbolName(), Lookup.MH.type(ScriptObject.class, PropertyMap.class));
            }
            return this.allocator.invokeExact(map);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private Object readResolve() {
        if (this.allocatorMap.size() == AllocationStrategy.DEFAULT_STRATEGY.allocatorMap.size() && this.allocatorClassName.equals(AllocationStrategy.DEFAULT_STRATEGY.allocatorClassName)) {
            return DEFAULT_STRATEGY;
        }
        return this;
    }

    public String toString() {
        return "AllocationStrategy[allocatorClassName=" + this.allocatorClassName + ", allocatorMap.size=" + this.allocatorMap.size() + "]";
    }
}

