/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.Comparator;

class TimSort<T> {
    private static final int MIN_MERGE = 32;
    private final T[] a;
    private final Comparator<? super T> c;
    private static final int MIN_GALLOP = 7;
    private int minGallop = 7;
    private static final int INITIAL_TMP_STORAGE_LENGTH = 256;
    private T[] tmp;
    private int tmpBase;
    private int tmpLen;
    private int stackSize = 0;
    private final int[] runBase;
    private final int[] runLen;

    private TimSort(T[] TArray, Comparator<? super T> comparator, T[] TArray2, int n, int n2) {
        int n3;
        this.a = TArray;
        this.c = comparator;
        int n4 = TArray.length;
        int n5 = n3 = n4 < 512 ? n4 >>> 1 : 256;
        if (TArray2 == null || n2 < n3 || n + n3 > TArray2.length) {
            Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n3);
            this.tmp = objectArray;
            this.tmpBase = 0;
            this.tmpLen = n3;
        } else {
            this.tmp = TArray2;
            this.tmpBase = n;
            this.tmpLen = n2;
        }
        int n6 = n4 < 120 ? 5 : (n4 < 1542 ? 10 : (n4 < 119151 ? 24 : 40));
        this.runBase = new int[n6];
        this.runLen = new int[n6];
    }

    static <T> void sort(T[] TArray, int n, int n2, Comparator<? super T> comparator, T[] TArray2, int n3, int n4) {
        int n5;
        assert (comparator != null && TArray != null && n >= 0 && n <= n2 && n2 <= TArray.length);
        int n6 = n2 - n;
        if (n6 < 2) {
            return;
        }
        if (n6 < 32) {
            int n7 = TimSort.countRunAndMakeAscending(TArray, n, n2, comparator);
            TimSort.binarySort(TArray, n, n2, n + n7, comparator);
            return;
        }
        TimSort<? super T> timSort = new TimSort<T>(TArray, comparator, TArray2, n3, n4);
        int n8 = TimSort.minRunLength(n6);
        do {
            if ((n5 = TimSort.countRunAndMakeAscending(TArray, n, n2, comparator)) < n8) {
                int n9 = n6 <= n8 ? n6 : n8;
                TimSort.binarySort(TArray, n, n + n9, n + n5, comparator);
                n5 = n9;
            }
            super.pushRun(n, n5);
            super.mergeCollapse();
            n += n5;
        } while ((n6 -= n5) != 0);
        assert (n == n2);
        super.mergeForceCollapse();
        assert (timSort.stackSize == 1);
    }

    private static <T> void binarySort(T[] TArray, int n, int n2, int n3, Comparator<? super T> comparator) {
        assert (n <= n3 && n3 <= n2);
        if (n3 == n) {
            ++n3;
        }
        while (n3 < n2) {
            int n4;
            T t = TArray[n3];
            int n5 = n;
            int n6 = n3;
            assert (n5 <= n6);
            while (n5 < n6) {
                n4 = n5 + n6 >>> 1;
                if (comparator.compare(t, TArray[n4]) < 0) {
                    n6 = n4;
                    continue;
                }
                n5 = n4 + 1;
            }
            assert (n5 == n6);
            n4 = n3 - n5;
            switch (n4) {
                case 2: {
                    TArray[n5 + 2] = TArray[n5 + 1];
                }
                case 1: {
                    TArray[n5 + 1] = TArray[n5];
                    break;
                }
                default: {
                    System.arraycopy(TArray, n5, TArray, n5 + 1, n4);
                }
            }
            TArray[n5] = t;
            ++n3;
        }
    }

    private static <T> int countRunAndMakeAscending(T[] TArray, int n, int n2, Comparator<? super T> comparator) {
        assert (n < n2);
        int n3 = n + 1;
        if (n3 == n2) {
            return 1;
        }
        if (comparator.compare(TArray[n3++], TArray[n]) < 0) {
            while (n3 < n2 && comparator.compare(TArray[n3], TArray[n3 - 1]) < 0) {
                ++n3;
            }
            TimSort.reverseRange(TArray, n, n3);
        } else {
            while (n3 < n2 && comparator.compare(TArray[n3], TArray[n3 - 1]) >= 0) {
                ++n3;
            }
        }
        return n3 - n;
    }

    private static void reverseRange(Object[] objectArray, int n, int n2) {
        --n2;
        while (n < n2) {
            Object object = objectArray[n];
            objectArray[n++] = objectArray[n2];
            objectArray[n2--] = object;
        }
    }

    private static int minRunLength(int n) {
        assert (n >= 0);
        int n2 = 0;
        while (n >= 32) {
            n2 |= n & 1;
            n >>= 1;
        }
        return n + n2;
    }

    private void pushRun(int n, int n2) {
        this.runBase[this.stackSize] = n;
        this.runLen[this.stackSize] = n2;
        ++this.stackSize;
    }

    private void mergeCollapse() {
        while (this.stackSize > 1) {
            int n = this.stackSize - 2;
            if (n > 0 && this.runLen[n - 1] <= this.runLen[n] + this.runLen[n + 1]) {
                if (this.runLen[n - 1] < this.runLen[n + 1]) {
                    --n;
                }
                this.mergeAt(n);
                continue;
            }
            if (this.runLen[n] > this.runLen[n + 1]) break;
            this.mergeAt(n);
        }
    }

    private void mergeForceCollapse() {
        while (this.stackSize > 1) {
            int n = this.stackSize - 2;
            if (n > 0 && this.runLen[n - 1] < this.runLen[n + 1]) {
                --n;
            }
            this.mergeAt(n);
        }
    }

    private void mergeAt(int n) {
        assert (this.stackSize >= 2);
        assert (n >= 0);
        assert (n == this.stackSize - 2 || n == this.stackSize - 3);
        int n2 = this.runBase[n];
        int n3 = this.runLen[n];
        int n4 = this.runBase[n + 1];
        int n5 = this.runLen[n + 1];
        assert (n3 > 0 && n5 > 0);
        assert (n2 + n3 == n4);
        this.runLen[n] = n3 + n5;
        if (n == this.stackSize - 3) {
            this.runBase[n + 1] = this.runBase[n + 2];
            this.runLen[n + 1] = this.runLen[n + 2];
        }
        --this.stackSize;
        int n6 = TimSort.gallopRight(this.a[n4], this.a, n2, n3, 0, this.c);
        assert (n6 >= 0);
        n2 += n6;
        if ((n3 -= n6) == 0) {
            return;
        }
        n5 = TimSort.gallopLeft(this.a[n2 + n3 - 1], this.a, n4, n5, n5 - 1, this.c);
        assert (n5 >= 0);
        if (n5 == 0) {
            return;
        }
        if (n3 <= n5) {
            this.mergeLo(n2, n3, n4, n5);
        } else {
            this.mergeHi(n2, n3, n4, n5);
        }
    }

    private static <T> int gallopLeft(T t, T[] TArray, int n, int n2, int n3, Comparator<? super T> comparator) {
        int n4;
        assert (n2 > 0 && n3 >= 0 && n3 < n2);
        int n5 = 0;
        int n6 = 1;
        if (comparator.compare(t, TArray[n + n3]) > 0) {
            n4 = n2 - n3;
            while (n6 < n4 && comparator.compare(t, TArray[n + n3 + n6]) > 0) {
                n5 = n6;
                if ((n6 = (n6 << 1) + 1) > 0) continue;
                n6 = n4;
            }
            if (n6 > n4) {
                n6 = n4;
            }
            n5 += n3;
            n6 += n3;
        } else {
            n4 = n3 + 1;
            while (n6 < n4 && comparator.compare(t, TArray[n + n3 - n6]) <= 0) {
                n5 = n6;
                if ((n6 = (n6 << 1) + 1) > 0) continue;
                n6 = n4;
            }
            if (n6 > n4) {
                n6 = n4;
            }
            int n7 = n5;
            n5 = n3 - n6;
            n6 = n3 - n7;
        }
        assert (-1 <= n5 && n5 < n6 && n6 <= n2);
        ++n5;
        while (n5 < n6) {
            n4 = n5 + (n6 - n5 >>> 1);
            if (comparator.compare(t, TArray[n + n4]) > 0) {
                n5 = n4 + 1;
                continue;
            }
            n6 = n4;
        }
        assert (n5 == n6);
        return n6;
    }

    private static <T> int gallopRight(T t, T[] TArray, int n, int n2, int n3, Comparator<? super T> comparator) {
        int n4;
        assert (n2 > 0 && n3 >= 0 && n3 < n2);
        int n5 = 1;
        int n6 = 0;
        if (comparator.compare(t, TArray[n + n3]) < 0) {
            n4 = n3 + 1;
            while (n5 < n4 && comparator.compare(t, TArray[n + n3 - n5]) < 0) {
                n6 = n5;
                if ((n5 = (n5 << 1) + 1) > 0) continue;
                n5 = n4;
            }
            if (n5 > n4) {
                n5 = n4;
            }
            int n7 = n6;
            n6 = n3 - n5;
            n5 = n3 - n7;
        } else {
            n4 = n2 - n3;
            while (n5 < n4 && comparator.compare(t, TArray[n + n3 + n5]) >= 0) {
                n6 = n5;
                if ((n5 = (n5 << 1) + 1) > 0) continue;
                n5 = n4;
            }
            if (n5 > n4) {
                n5 = n4;
            }
            n6 += n3;
            n5 += n3;
        }
        assert (-1 <= n6 && n6 < n5 && n5 <= n2);
        ++n6;
        while (n6 < n5) {
            n4 = n6 + (n5 - n6 >>> 1);
            if (comparator.compare(t, TArray[n + n4]) < 0) {
                n5 = n4;
                continue;
            }
            n6 = n4 + 1;
        }
        assert (n6 == n5);
        return n5;
    }

    private void mergeLo(int n, int n2, int n3, int n4) {
        assert (n2 > 0 && n4 > 0 && n + n2 == n3);
        T[] TArray = this.a;
        T[] TArray2 = this.ensureCapacity(n2);
        int n5 = this.tmpBase;
        int n6 = n3;
        int n7 = n;
        System.arraycopy(TArray, n, TArray2, n5, n2);
        TArray[n7++] = TArray[n6++];
        if (--n4 == 0) {
            System.arraycopy(TArray2, n5, TArray, n7, n2);
            return;
        }
        if (n2 == 1) {
            System.arraycopy(TArray, n6, TArray, n7, n4);
            TArray[n7 + n4] = TArray2[n5];
            return;
        }
        Comparator<T> comparator = this.c;
        int n8 = this.minGallop;
        block0: while (true) {
            int n9 = 0;
            int n10 = 0;
            do {
                assert (n2 > 1 && n4 > 0);
                if (comparator.compare(TArray[n6], TArray2[n5]) < 0) {
                    TArray[n7++] = TArray[n6++];
                    ++n10;
                    n9 = 0;
                    if (--n4 != 0) continue;
                    break block0;
                }
                TArray[n7++] = TArray2[n5++];
                ++n9;
                n10 = 0;
                if (--n2 == 1) break block0;
            } while ((n9 | n10) < n8);
            do {
                assert (n2 > 1 && n4 > 0);
                n9 = TimSort.gallopRight(TArray[n6], TArray2, n5, n2, 0, comparator);
                if (n9 != 0) {
                    System.arraycopy(TArray2, n5, TArray, n7, n9);
                    n7 += n9;
                    n5 += n9;
                    if ((n2 -= n9) <= 1) break block0;
                }
                TArray[n7++] = TArray[n6++];
                if (--n4 == 0) break block0;
                n10 = TimSort.gallopLeft(TArray2[n5], TArray, n6, n4, 0, comparator);
                if (n10 != 0) {
                    System.arraycopy(TArray, n6, TArray, n7, n10);
                    n7 += n10;
                    n6 += n10;
                    if ((n4 -= n10) == 0) break block0;
                }
                TArray[n7++] = TArray2[n5++];
                if (--n2 == 1) break block0;
                --n8;
            } while (n9 >= 7 | n10 >= 7);
            if (n8 < 0) {
                n8 = 0;
            }
            n8 += 2;
        }
        int n11 = this.minGallop = n8 < 1 ? 1 : n8;
        if (n2 == 1) {
            assert (n4 > 0);
            System.arraycopy(TArray, n6, TArray, n7, n4);
            TArray[n7 + n4] = TArray2[n5];
        } else {
            if (n2 == 0) {
                throw new IllegalArgumentException("Comparison method violates its general contract!");
            }
            assert (n4 == 0);
            assert (n2 > 1);
            System.arraycopy(TArray2, n5, TArray, n7, n2);
        }
    }

    private void mergeHi(int n, int n2, int n3, int n4) {
        assert (n2 > 0 && n4 > 0 && n + n2 == n3);
        T[] TArray = this.a;
        T[] TArray2 = this.ensureCapacity(n4);
        int n5 = this.tmpBase;
        System.arraycopy(TArray, n3, TArray2, n5, n4);
        int n6 = n + n2 - 1;
        int n7 = n5 + n4 - 1;
        int n8 = n3 + n4 - 1;
        TArray[n8--] = TArray[n6--];
        if (--n2 == 0) {
            System.arraycopy(TArray2, n5, TArray, n8 - (n4 - 1), n4);
            return;
        }
        if (n4 == 1) {
            System.arraycopy(TArray, (n6 -= n2) + 1, TArray, (n8 -= n2) + 1, n2);
            TArray[n8] = TArray2[n7];
            return;
        }
        Comparator<T> comparator = this.c;
        int n9 = this.minGallop;
        block0: while (true) {
            int n10 = 0;
            int n11 = 0;
            do {
                assert (n2 > 0 && n4 > 1);
                if (comparator.compare(TArray2[n7], TArray[n6]) < 0) {
                    TArray[n8--] = TArray[n6--];
                    ++n10;
                    n11 = 0;
                    if (--n2 != 0) continue;
                    break block0;
                }
                TArray[n8--] = TArray2[n7--];
                ++n11;
                n10 = 0;
                if (--n4 == 1) break block0;
            } while ((n10 | n11) < n9);
            do {
                assert (n2 > 0 && n4 > 1);
                n10 = n2 - TimSort.gallopRight(TArray2[n7], TArray, n, n2, n2 - 1, comparator);
                if (n10 != 0) {
                    System.arraycopy(TArray, (n6 -= n10) + 1, TArray, (n8 -= n10) + 1, n10);
                    if ((n2 -= n10) == 0) break block0;
                }
                TArray[n8--] = TArray2[n7--];
                if (--n4 == 1) break block0;
                n11 = n4 - TimSort.gallopLeft(TArray[n6], TArray2, n5, n4, n4 - 1, comparator);
                if (n11 != 0) {
                    System.arraycopy(TArray2, (n7 -= n11) + 1, TArray, (n8 -= n11) + 1, n11);
                    if ((n4 -= n11) <= 1) break block0;
                }
                TArray[n8--] = TArray[n6--];
                if (--n2 == 0) break block0;
                --n9;
            } while (n10 >= 7 | n11 >= 7);
            if (n9 < 0) {
                n9 = 0;
            }
            n9 += 2;
        }
        int n12 = this.minGallop = n9 < 1 ? 1 : n9;
        if (n4 == 1) {
            assert (n2 > 0);
            System.arraycopy(TArray, (n6 -= n2) + 1, TArray, (n8 -= n2) + 1, n2);
            TArray[n8] = TArray2[n7];
        } else {
            if (n4 == 0) {
                throw new IllegalArgumentException("Comparison method violates its general contract!");
            }
            assert (n2 == 0);
            assert (n4 > 0);
            System.arraycopy(TArray2, n5, TArray, n8 - (n4 - 1), n4);
        }
    }

    private T[] ensureCapacity(int n) {
        if (this.tmpLen < n) {
            int n2 = n;
            n2 |= n2 >> 1;
            n2 |= n2 >> 2;
            n2 |= n2 >> 4;
            n2 |= n2 >> 8;
            n2 |= n2 >> 16;
            n2 = ++n2 < 0 ? n : Math.min(n2, this.a.length >>> 1);
            Object[] objectArray = (Object[])Array.newInstance(this.a.getClass().getComponentType(), n2);
            this.tmp = objectArray;
            this.tmpLen = n2;
            this.tmpBase = 0;
        }
        return this.tmp;
    }
}

