/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.PropertyNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class ObjectNode
extends Expression {
    private static final long serialVersionUID = 1L;
    private final List<PropertyNode> elements;

    public ObjectNode(long token, int finish, List<PropertyNode> elements) {
        super(token, finish);
        this.elements = elements;
    }

    private ObjectNode(ObjectNode objectNode, List<PropertyNode> elements) {
        super(objectNode);
        this.elements = elements;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterObjectNode(this)) {
            return visitor.leaveObjectNode(this.setElements(Node.accept(visitor, this.elements)));
        }
        return this;
    }

    @Override
    public Type getType(Function<Symbol, Type> localVariableTypes) {
        return Type.OBJECT;
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        sb.append('{');
        if (!this.elements.isEmpty()) {
            sb.append(' ');
            boolean first = true;
            for (Node node : this.elements) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                node.toString(sb, printType);
            }
            sb.append(' ');
        }
        sb.append('}');
    }

    public List<PropertyNode> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    private ObjectNode setElements(List<PropertyNode> elements) {
        if (this.elements == elements) {
            return this;
        }
        return new ObjectNode(this, elements);
    }
}

